/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.ventas;

import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import ec.gob.sri.dimm.ats.modelo.obj.ventas.Venta;
import ec.gob.sri.dimm.ats.modelo.validator.rule.VentasValidationRule;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ventas.PaginaComprobanteVenta;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.ventas.PaginaFormasDeCobro;
import java.util.AbstractMap;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteEdicionComprobanteVenta
extends AsistenteBase
implements INewWizard {
    private PaginaComprobanteVenta paginaComprobanteVenta;
    private PaginaFormasDeCobro formasDeCobro;
    private final ComprobanteVenta modeloDatos;
    private final Periodo periodo;
    private final List<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes;
    private final SeccionVenta seccion;

    public AsistenteEdicionComprobanteVenta(ComprobanteVenta comprobanteVenta, List<AbstractMap.SimpleEntry<String, String>> comprobantesExistentes, SeccionVenta seccion) {
        this.comprobantesExistentes = comprobantesExistentes;
        this.modeloDatos = comprobanteVenta;
        this.seccion = seccion;
        this.periodo = ((Iva)((Venta)comprobanteVenta.getPropietario()).getPropietario()).periodo;
    }

    public void addPages() {
        switch (this.seccion) {
            case COMPROBANTE: {
                this.paginaComprobanteVenta = new PaginaComprobanteVenta(true, this.periodo, this.comprobantesExistentes);
                this.paginaComprobanteVenta.setModeloDatos(this.modeloDatos);
                this.paginaComprobanteVenta.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaComprobanteVenta);
                break;
            }
            case FORMAS_COBRO: {
                boolean esNotaDeCredito = VentasValidationRule.esNotaDeCreditoEnVentas((ComprobanteVenta)this.modeloDatos);
                this.formasDeCobro = new PaginaFormasDeCobro(esNotaDeCredito, this.periodo);
                this.formasDeCobro.setModeloDatos(this.modeloDatos);
                this.formasDeCobro.inicializarModeloValores();
                this.addPage((IWizardPage)this.formasDeCobro);
                break;
            }
        }
    }

    public boolean performFinish() {
        return this.eliminarFormasDePagoConNotaDeCredito();
    }

    private boolean eliminarFormasDePagoConNotaDeCredito() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        boolean esNotaDebitoCredito = VentasValidationRule.esNotaDeCreditoEnVentas((ComprobanteVenta)this.modeloDatos);
        if (currentPage instanceof PaginaComprobanteVenta && esNotaDebitoCredito) {
            if (this.mostrarPregunta("El tipo de comprobante es una nota de cr\u00e9dito\nEn caso de existir formas de cobro,, estas ser\u00e1n eliminidas\n\u00bfDesea continuar?")) {
                this.modeloDatos.getFormasCobro().clear();
                return true;
            }
            return false;
        }
        return true;
    }

    public static enum SeccionVenta {
        COMPROBANTE,
        FORMAS_COBRO;

    }
}

